import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:wordpress_app/blocs/theme_bloc.dart';
import '../config/config.dart';

class AppLogo extends ConsumerWidget {
  const AppLogo({super.key, required this.height, this.width});
  final double height;
  final double? width;

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    final isDarkMode = ref.watch(themeBlocProvider).darkTheme ?? false;
    return Image(
      image: AssetImage(
        !isDarkMode ? Config.logo : Config.logoDark,
      ),
      height: height,
      width: width,
      fit: BoxFit.contain,
    );
  }
}
